#ifndef CRFEPUREXPERIMENTALSETTINGS_H
#define CRFEPUREXPERIMENTALSETTINGS_H

#include "../../ui/TabWidget.h"
#include "../../ui/ConfigDialog.h"
#include <ui_CRfePurExperimentalSettings.h>

class QrfeRfePurReader;

class QwtPlot;
class QwtPlotCurve;

class CRfePurExperimentalSettings : public ReaderTabWidget, ConfigDialog
{
    Q_OBJECT

public:
    CRfePurExperimentalSettings(QTextEdit* infoEdit, QWidget* parent);
    ~CRfePurExperimentalSettings();

	virtual bool init(QrfeReaderInterface* reader);
	virtual void deinit();
	virtual void activated();

private slots:
	void reloadSettings();

	void setOAD();
	void setTariSettings();
	void setLinkFrequency();
    void setLongPreamble();
    void setModulatorSettings();
    void setPredistortionData();
    void getPredistortionData();
    void setReadParams();

private:
    void clearPlot();

private:
    QrfeRfePurReader* 		m_reader;

    Ui::CRfePurExperimentalSettingsClass ui;

    QList<double>			m_predistData;
    QList<double> 			m_predistIndex;

    QwtPlot*				m_predistDataPlot;
    QwtPlotCurve*			m_predistDataCurve;
};

#endif // CRFEPUREXPERIMENTALSETTINGS_H
